﻿<%@ Page Title="" Language="C#" MasterPageFile="~/site_base.master" AutoEventWireup="true" CodeFile="index.aspx.cs" Inherits="index" %>

<script runat="server">
    String version = WebAppVersion.GetWebAppVersion();
    bool withModules = false; 
</script>

<%@ Import Namespace="System.Threading" %>
<%@ Import Namespace="System.Globalization" %>
<script runat="server">
string siteLang = "EN"; 
protected override void InitializeCulture()
{
    HttpCookie lang = Request.Cookies["siteLanguage"]; 
    
    siteLang = (lang != null) ? lang.Value : siteLang;
    UICulture = siteLang ;
    Culture = siteLang ;

    Thread.CurrentThread.CurrentCulture = 
        CultureInfo.CreateSpecificCulture(siteLang);
    Thread.CurrentThread.CurrentUICulture = new 
        CultureInfo(siteLang);
    base.InitializeCulture();
}
</script>

<asp:Content ID="head" ContentPlaceHolderID="baseHead" Runat="Server">

    <title>IHBox</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <!--getting all assets from a CDN-->
    <!--<script src="http://code.jquery.com/jquery-1.8.0.min.js"></script>
    <script src="http://cdnjs.cloudflare.com/ajax/libs/underscore.js/1.3.3/underscore-min.js"></script>
    <script src="http://cdnjs.cloudflare.com/ajax/libs/backbone.js/0.9.2/backbone-min.js"></script>
    <script src="http://cdnjs.cloudflare.com/ajax/libs/handlebars.js/1.0.0-rc.3/handlebars.js"></script>
    <script src="http://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/2.3.0/js/bootstrap.min.js"></script>
    <link href="http://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/2.3.0/css/bootstrap.css" rel="stylesheet" type="text/css" />
    <link href="http://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/2.3.0/css/bootstrap-responsive.css" rel="stylesheet" type="text/css" />-->

    <!--working with local copies -->
    
    <% 
        bool debug = true;
    %>

    <!-- industrial dashboard css & js -->
    <script src="<%
        
        if (debug == true){
            Response.Write(ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Scripts/IndustrialDashboard-debug.js?v=" + version)); 
        } else {
            Response.Write(ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Scripts/IndustrialDashboard.js?v=" + version)); 
        }
        
        %>" type="text/javascript"></script> 

    <link type="text/css" href="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Styles/IndustrialDashboard.css?v=" + version) %>" rel="stylesheet" />

    <%--jquery--%>
    <script src="<%= ResolveUrl("~/assets/libs/jam/jquery/dist/jquery.js") %>"></script>

    <!-- nprogress bar for ajax loading feedback -->
    <link href="<%= ResolveUrl("~/assets/libs/js/nprogress/nprogress.css") %>" rel="stylesheet" />
    <script src="<%= ResolveUrl("~/assets/libs/js/nprogress/nprogress.js") %>"></script>

    <script>
        <%    
            string locale_data = getJedLocaleData(siteLang); //all code is on the index.aspx.cs file
            Response.Write("var jed_locale_data =" + locale_data + ";");

            string custom_modules = getCustomModulesPaths();
            Response.Write("var custom_modules_paths = " + custom_modules + ";");
            
            string custom_configs = getCustomConfigsPaths();
            Response.Write("var custom_configs_paths = " + custom_configs + ";"); 
        %>
    </script>

    <!--bootstrap-->
    <link href="<%= ResolveUrl("~/assets/bootstrap/css/custom-bootstrap.min.css") %>" rel="stylesheet" />
    <%--<link href="<%= ResolveUrl("~/assets/bootstrap-3.2.0/css/bootstrap.min.css") %>" rel="stylesheet" />--%>
    <link href="<%= ResolveUrl("~/assets/css/font-awesome/css/font-awesome.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/css/font-awesome-4.2.0/css/font-awesome.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/css/font-awesome-animation-0.0.7/css/font-awesome-animation.css") %>" rel="stylesheet" />

    <!--rule for body padding, between normal css and responsive css to
    fix and show content properly and also consider the responsive change from fixed
    to relative (nav-top fixed)-->
    <style type="text/css">
        body {
            padding-top: 53px;
            /*padding-top: 93px;*/
            /*padding-bottom: 40px;*/
        }

        /* Large desktop */
        @media (min-width: 1250px) { 
            #header .btn, #header .nav li > a, #header .nav span{
                font-size:18px !important; 
            }
        }
 
        /* Portrait tablet to landscape and desktop */
        @media (max-width: 1250px) { 
            #header .btn, #header .nav li > a, #header .nav span{
                font-size:14px !important; 
            }
        }

    </style>

    <link href="<%= ResolveUrl("~/assets/bootstrap/css/bootstrap-responsive.css") %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/css/index-ui.css?v=" + version) %>" rel="stylesheet" />
    <%--<link href="<%= ResolveUrl("~/assets/css/index-ui-flat.css") %>" rel="stylesheet" />--%>
    <%--<link href="<%= ResolveUrl("~/assets/css/index-ui-flat2.css") %>" rel="stylesheet" />--%>
    
    <style type="text/css">
        @media (max-width: 979px) {
            body {
                padding-top: 53px;
            }
        }

        #configuration_error_icon {
            float: right;
            margin-top: -25px;
            margin-right: 15px;
            height: 12px;
            width: 12px;
            background-color: #FF0000;
            -moz-border-radius: 43px;
            -webkit-border-radius: 43px;
            border-radius: 43px;
            color: #FFFFFF;
            font-size: 10px;
            line-height: 12px;
            text-align: center;
            display:none;
        }
    </style>

    <%--<link rel="stylesheet" href="http://fonts.googleapis.com/css?family=Raleway:600,400,500,300,100,700" type="text/css">--%>
    <link href="<%= ResolveUrl("~/assets/css/index-ui-template.css?v=" + version) %>" rel="stylesheet" />
    <link href="<%= ResolveUrl("~/assets/css/animate.css") %>" rel="stylesheet" />

    <script type="text/javascript">
        var _Includer = new window.Includer({
            Widgets: [
                'SecurityLogin'
            ]
            , ExternalWidgets: [
            ]
            , XML: { Available: false }
            , Theme: "ABGPortal"
        });
    </script>

</asp:Content>
<asp:Content ID="body" ContentPlaceHolderID="baseBody" Runat="Server">

    <% WebApp.MenuData menuData = (WebApp.MenuData) Session["MenuData"]; %>
    <%--<script data-main="<%= ResolveUrl("~/app/config")%>" src="<%= ResolveUrl("~/assets/libs/js/require.js") %>"></script>--%>

    <script src="<%= ResolveUrl("~/assets/libs/js/require.js") %>"></script>

    <div id="top_messages_bar_container">
        <!--here goes the top messages bar -->
    </div>

    <header id="tz-header-wrapper" class="big-blue-header navbar-fixed-top" style="position: fixed; top: 0px;">
        <div style="position:relative; top:0; height:40px; background:#ee4c4c; width:100%;text-align:center;" class="update-available hide">
            <span style="color:#fff; line-height:40px;"><asp:Localize ID="Localize4" runat="server" meta:resourcekey="new_version_available" /> <a style="color:#fff;text-decoration:underline;" href="javascript: window.location.reload(true);"><asp:Localize ID="Localize5" runat="server" meta:resourcekey="new_version_available_click_here" /></a></span>
        </div>
        <div style="position:relative; top:0; height:40px; background:#ffd800; width:100%;text-align:center;" class="zoomed-browser-notice hide">
            <span style="color:#000; line-height:40px;"><asp:Localize ID="Localize6" runat="server" meta:resourcekey="zoomed_browser_notice" /></span>
            <button style="margin-top:11px;margin-right:30px;opacity:0.7;" class="close dismiss-zoomed-browser-notice" aria-hidden="true">&times;</button>
        </div>
        <div class="container-fluid" style="max-width:none;">
            <div class="row-fluid" id="header">
                <div class="span12">
                    <div id="tz-menu" class="pull-left">
                        <!-- MAIN NAVIGATION -->
                        <nav id="plazart-mainnav" class="wrap plazart-mainnav navbar-collapse-fixed-top">
                            <div class="container navbar">
                                <div class="navbar-inner">
                                    <button type="button" class="btn btn-navbar" data-toggle="collapse" data-target=".nav-collapse">
                                        <i class="fw fw-icon-reorder"></i>
                                    </button>
                                    <div class="nav-collapse collapse always-show">
                                        <div class="plazart-megamenu animate slide" data-duration="400">
                                            <% if (withModules){ %>
                                            <ul class="nav navbar-nav level0">
                                                <% foreach(WebApp.MenuItem mi in menuData.GetGroupItems("navbar_left_with_modules")){ %>
                                                <li class="<% = (mi.Properties.HasProperty("classes")) ? mi.Properties.GetPropertyValue("classes") : "" %>" data-id="101" data-level="1">
                                                    <% if (mi.Children.Count > 0){ %>
                                                    <a class="dropdown-toggle" style="padding: 17px 31px;font-size: 18px;font-weight: normal;cursor:pointer;" data-toggle="dropdown">
                                                        <% if (mi.Properties.HasProperty("icon")){ %>
                                                            <i style="line-height:0px;" class="<% = mi.Properties.GetPropertyValue("icon") %>"></i>
                                                        <% } %>
                                                        <% if (mi.Properties.HasProperty("localize-key")){ %>
                                                            <% =GetLocalResourceObject(mi.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                        <% }else{ %>
                                                            <span><% = mi.Name %></span>
                                                        <% } %>
                                                        <span class="caret"></span>
                                                    </a>
                                                    <ul style="min-width:190px;margin-left:5px;color: rgb(0, 0, 0);" class="dropdown-menu">
                                                        <% foreach(WebApp.MenuItem child in mi.Children){ %>
                                                            <li class="<% = (child.Properties.HasProperty("classes")) ? child.Properties.GetPropertyValue("classes") : "" %>" data-id="101" data-level="1">
                                                                <% if (child.Children.Count > 0){ %>
                                                                <a class="dropdown-toggle" style="padding: 17px 31px;font-size: 18px;font-weight: normal;cursor:pointer;" data-toggle="dropdown">
                                                                    <% if (child.Properties.HasProperty("icon")){ %>
                                                                        <i style="line-height:0px;" class="<% = child.Properties.GetPropertyValue("icon") %>"></i>
                                                                    <% } %>
                                                                    <% if (child.Properties.HasProperty("localize-key")){ %>
                                                                        <% =GetLocalResourceObject(child.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                                    <% }else{ %>
                                                                        <span><% = child.Name %></span>
                                                                    <% } %>
                                                                    <span class="caret"></span>
                                                                </a>
                                                                <ul style="min-width:190px;margin-left:5px;color: rgb(0, 0, 0);" class="dropdown-menu">
                                                                    <% foreach(WebApp.MenuItem child1 in child.Children){ %>
                                                                        <a href="<% = child1.URL %>" style="padding: 25px 31px;">
                                                                            <% if (child1.Properties.HasProperty("icon")){ %>
                                                                                <i style="line-height:0px;" class="<% = child1.Properties.GetPropertyValue("icon") %>"></i>
                                                                            <% } %>
                                                                            <% if (child1.Properties.HasProperty("localize-key")){ %>
                                                                                <% =GetLocalResourceObject(child1.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                                            <% }else{ %>
                                                                                <span><% = child1.Name %></span>
                                                                            <% } %>
                                                                        </a>
                                                                    <% } %>
                                                                </ul>
                                                                <% }else{ %>
                                                                <a href="<% = child.URL %>" style="padding: 25px 31px;">
                                                                    <% if (child.Properties.HasProperty("icon")){ %>
                                                                        <i style="line-height:0px;" class="<% = child.Properties.GetPropertyValue("icon") %>"></i>
                                                                    <% } %>
                                                                    <% if (child.Properties.HasProperty("localize-key")){ %>
                                                                        <% =GetLocalResourceObject(child.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                                    <% }else{ %>
                                                                        <span><% = child.Name %></span>
                                                                    <% } %>
                                                                </a>
                                                                <% } %>
                                                            </li>
                                                        <% } %>
                                                    </ul>
                                                    <% }else{ %>
                                                    <a href="<% = mi.URL %>" style="padding: 25px 31px;">
                                                        <% if (mi.Properties.HasProperty("icon")){ %>
                                                            <i style="line-height:0px;" class="<% = mi.Properties.GetPropertyValue("icon") %>"></i>
                                                        <% } %>
                                                        <% if (mi.Properties.HasProperty("localize-key")){ %>
                                                            <% =GetLocalResourceObject(mi.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                        <% }else{ %>
                                                            <span><% = mi.Name %></span>
                                                        <% } %>
                                                    </a>
                                                    <% } %>
                                                </li>
                                                <% } %>
                                            </ul>
                                            <% }else{ %>
                                            <ul class="nav navbar-nav level0">
                                                <% foreach (WebApp.MenuItem mi in menuData.GetGroupItems("navbar_left_no_modules")){ %>
                                                <li class="<% = (mi.Properties.HasProperty("classes")) ? mi.Properties.GetPropertyValue("classes") : "" %>" data-id="101" data-level="1">
                                                    <% if (mi.Children.Count > 0){ %>
                                                    <a class="dropdown-toggle" style="padding: 17px 31px;font-size: 18px;font-weight: normal;cursor:pointer;" data-toggle="dropdown">
                                                        <% if (mi.Properties.HasProperty("icon")){ %>
                                                            <i style="line-height:0px;" class="<% = mi.Properties.GetPropertyValue("icon") %>"></i>
                                                        <% } %>
                                                        <% if (mi.Properties.HasProperty("localize-key")){ %>
                                                            <% =GetLocalResourceObject(mi.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                        <% }else{ %>
                                                            <span><% = mi.Name %></span>
                                                        <% } %>
                                                        <span class="caret"></span>
                                                    </a>
                                                    <ul style="min-width:190px;margin-left:5px;color: rgb(0, 0, 0);" class="dropdown-menu">
                                                        <% foreach(WebApp.MenuItem child in mi.Children){ %>
                                                            <li class="<% = (child.Properties.HasProperty("classes")) ? child.Properties.GetPropertyValue("classes") : "" %>" data-id="101" data-level="1">
                                                                <% if (child.Children.Count > 0){ %>
                                                                <a class="dropdown-toggle" style="padding: 17px 31px;font-size: 18px;font-weight: normal;cursor:pointer;" data-toggle="dropdown">
                                                                    <% if (child.Properties.HasProperty("icon")){ %>
                                                                        <i style="line-height:0px;" class="<% = child.Properties.GetPropertyValue("icon") %>"></i>
                                                                    <% } %>
                                                                    <% if (child.Properties.HasProperty("localize-key")){ %>
                                                                        <% =GetLocalResourceObject(child.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                                    <% }else{ %>
                                                                        <span><% = child.Name %></span>
                                                                    <% } %>
                                                                    <span class="caret"></span>
                                                                </a>
                                                                <ul style="min-width:190px;margin-left:5px;color: rgb(0, 0, 0);" class="dropdown-menu">
                                                                    <% foreach(WebApp.MenuItem child1 in child.Children){ %>
                                                                        <a href="<% = child1.URL %>" style="padding: 25px 31px;">
                                                                            <% if (child1.Properties.HasProperty("icon")){ %>
                                                                                <i style="line-height:0px;" class="<% = child1.Properties.GetPropertyValue("icon") %>"></i>
                                                                            <% } %>
                                                                            <% if (child1.Properties.HasProperty("localize-key")){ %>
                                                                                <% =GetLocalResourceObject(child1.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                                            <% }else{ %>
                                                                                <span><% = child1.Name %></span>
                                                                            <% } %>
                                                                        </a>
                                                                    <% } %>
                                                                </ul>
                                                                <% }else{ %>
                                                                <a href="<% = child.URL %>" style="padding: 25px 31px;">
                                                                    <% if (child.Properties.HasProperty("icon")){ %>
                                                                        <i style="line-height:0px;" class="<% = child.Properties.GetPropertyValue("icon") %>"></i>
                                                                    <% } %>
                                                                    <% if (child.Properties.HasProperty("localize-key")){ %>
                                                                        <% =GetLocalResourceObject(child.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                                    <% }else{ %>
                                                                        <span><% = child.Name %></span>
                                                                    <% } %>
                                                                </a>
                                                                <% } %>
                                                            </li>
                                                        <% } %>
                                                    </ul>
                                                    <% }else{ %>
                                                    <a href="<% = mi.URL %>" style="padding: 25px 31px;">
                                                        <% if (mi.Properties.HasProperty("icon")){ %>
                                                            <i style="line-height:0px;" class="<% = mi.Properties.GetPropertyValue("icon") %>"></i>
                                                        <% } %>
                                                        <% if (mi.Properties.HasProperty("localize-key")){ %>
                                                            <% =GetLocalResourceObject(mi.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                        <% }else{ %>
                                                            <span><% = mi.Name %></span>
                                                        <% } %>
                                                    </a>
                                                    <% } %>
                                                </li>
                                                <% } %>
                                            </ul>
                                            <% } %>
                                            <ul class="nav navbar-nav level0">
                                                <% foreach (WebApp.MenuItem mi in menuData.GetGroupItems("navbar_left")){ %>
                                                <li class="<% = (mi.Properties.HasProperty("classes")) ? mi.Properties.GetPropertyValue("classes") : "" %>" data-id="101" data-level="1">
                                                    <% if (mi.Children.Count > 0){ %>
                                                    <a class="dropdown-toggle" style="padding: 17px 31px;font-size: 18px;font-weight: normal;cursor:pointer;" data-toggle="dropdown">
                                                        <% if (mi.Properties.HasProperty("icon")){ %>
                                                            <i style="line-height:0px;" class="<% = mi.Properties.GetPropertyValue("icon") %>"></i>
                                                        <% } %>
                                                        <% if (mi.Properties.HasProperty("localize-key")){ %>
                                                            <% =GetLocalResourceObject(mi.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                        <% }else{ %>
                                                            <span><% = mi.Name %></span>
                                                        <% } %>
                                                        <span class="caret"></span>
                                                    </a>
                                                    <ul style="min-width:190px;margin-left:5px;color: rgb(0, 0, 0);" class="dropdown-menu">
                                                        <% foreach(WebApp.MenuItem child in mi.Children){ %>
                                                            <li class="<% = (child.Properties.HasProperty("classes")) ? child.Properties.GetPropertyValue("classes") : "" %>" data-id="101" data-level="1">
                                                                <% if (child.Children.Count > 0){ %>
                                                                <a class="dropdown-toggle" style="padding: 17px 31px;font-size: 18px;font-weight: normal;cursor:pointer;" data-toggle="dropdown">
                                                                    <% if (child.Properties.HasProperty("icon")){ %>
                                                                        <i style="line-height:0px;" class="<% = child.Properties.GetPropertyValue("icon") %>"></i>
                                                                    <% } %>
                                                                    <% if (child.Properties.HasProperty("localize-key")){ %>
                                                                        <% =GetLocalResourceObject(child.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                                    <% }else{ %>
                                                                        <span><% = child.Name %></span>
                                                                    <% } %>
                                                                    <span class="caret"></span>
                                                                </a>
                                                                <ul style="min-width:190px;margin-left:5px;color: rgb(0, 0, 0);" class="dropdown-menu">
                                                                    <% foreach(WebApp.MenuItem child1 in child.Children){ %>
                                                                        <a href="<% = child1.URL %>" style="padding: 25px 31px;">
                                                                            <% if (child1.Properties.HasProperty("icon")){ %>
                                                                                <i style="line-height:0px;" class="<% = child1.Properties.GetPropertyValue("icon") %>"></i>
                                                                            <% } %>
                                                                            <% if (child1.Properties.HasProperty("localize-key")){ %>
                                                                                <% =GetLocalResourceObject(child1.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                                            <% }else{ %>
                                                                                <span><% = child1.Name %></span>
                                                                            <% } %>
                                                                        </a>
                                                                    <% } %>
                                                                </ul>
                                                                <% }else{ %>
                                                                <a href="<% = child.URL %>" style="padding: 25px 31px;">
                                                                    <% if (child.Properties.HasProperty("icon")){ %>
                                                                        <i style="line-height:0px;" class="<% = child.Properties.GetPropertyValue("icon") %>"></i>
                                                                    <% } %>
                                                                    <% if (child.Properties.HasProperty("localize-key")){ %>
                                                                        <% =GetLocalResourceObject(child.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                                    <% }else{ %>
                                                                        <span><% = child.Name %></span>
                                                                    <% } %>
                                                                </a>
                                                                <% } %>
                                                            </li>
                                                        <% } %>
                                                    </ul>
                                                    <% }else{ %>
                                                    <a href="<% = mi.URL %>" style="padding: 25px 31px;">
                                                        <% if (mi.Properties.HasProperty("icon")){ %>
                                                            <i style="line-height:0px;" class="<% = mi.Properties.GetPropertyValue("icon") %>"></i>
                                                        <% } %>
                                                        <% if (mi.Properties.HasProperty("localize-key")){ %>
                                                            <% =GetLocalResourceObject(mi.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                        <% }else{ %>
                                                            <span><% = mi.Name %></span>
                                                        <% } %>
                                                    </a>
                                                    <% } %>
                                                </li>
                                                <% } %>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </nav>
                        <!-- //MAIN NAVIGATION -->
                    </div>
                    <div class="pull-right">
                        <!-- MAIN NAVIGATION -->
                        <nav class="wrap plazart-mainnav navbar-collapse-fixed-top">
                            <div class="container navbar">
                                <div class="navbar-inner">
                                    <div class="nav-collapse collapse always-show">
                                        <div class="plazart-megamenu animate slide pull-right" data-duration="400">
                                            <% if (withModules){ %>
                                            <ul class="nav navbar-nav level0">
                                                <% foreach (WebApp.MenuItem mi in menuData.GetGroupItems("navbar_right_with_modules"))
                                                   { %>
                                                <li class="<% = (mi.Properties.HasProperty("classes")) ? mi.Properties.GetPropertyValue("classes") : "" %>" data-id="101" data-level="1">
                                                    <% if (mi.Children.Count > 0){ %>
                                                    <a class="dropdown-toggle" style="padding: 17px 31px;font-size: 18px;font-weight: normal;cursor:pointer;" data-toggle="dropdown">
                                                        <% if (mi.Properties.HasProperty("icon")){ %>
                                                            <i style="line-height:0px;" class="<% = mi.Properties.GetPropertyValue("icon") %>"></i>
                                                        <% } %>
                                                        <% if (mi.Properties.HasProperty("localize-key")){ %>
                                                            <% =GetLocalResourceObject(mi.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                        <% }else{ %>
                                                            <span><% = mi.Name %></span>
                                                        <% } %>
                                                        <span class="caret"></span>
                                                    </a>
                                                    <ul style="min-width:190px;margin-left:5px;color: rgb(0, 0, 0);" class="dropdown-menu">
                                                        <% foreach(WebApp.MenuItem child in mi.Children){ %>
                                                            <li class="<% = (child.Properties.HasProperty("classes")) ? child.Properties.GetPropertyValue("classes") : "" %>" data-id="101" data-level="1">
                                                                <% if (child.Children.Count > 0){ %>
                                                                <a class="dropdown-toggle" style="padding: 17px 31px;font-size: 18px;font-weight: normal;cursor:pointer;" data-toggle="dropdown">
                                                                    <% if (child.Properties.HasProperty("icon")){ %>
                                                                        <i style="line-height:0px;" class="<% = child.Properties.GetPropertyValue("icon") %>"></i>
                                                                    <% } %>
                                                                    <% if (child.Properties.HasProperty("localize-key")){ %>
                                                                        <% =GetLocalResourceObject(child.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                                    <% }else{ %>
                                                                        <span><% = child.Name %></span>
                                                                    <% } %>
                                                                    <span class="caret"></span>
                                                                </a>
                                                                <ul style="min-width:190px;margin-left:5px;color: rgb(0, 0, 0);" class="dropdown-menu">
                                                                    <% foreach(WebApp.MenuItem child1 in child.Children){ %>
                                                                        <a href="<% = child1.URL %>" style="padding: 25px 31px;">
                                                                            <% if (child1.Properties.HasProperty("icon")){ %>
                                                                                <i style="line-height:0px;" class="<% = child1.Properties.GetPropertyValue("icon") %>"></i>
                                                                            <% } %>
                                                                            <% if (child1.Properties.HasProperty("localize-key")){ %>
                                                                                <% =GetLocalResourceObject(child1.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                                            <% }else{ %>
                                                                                <span><% = child1.Name %></span>
                                                                            <% } %>
                                                                        </a>
                                                                    <% } %>
                                                                </ul>
                                                                <% }else{ %>
                                                                <a href="<% = child.URL %>" style="padding: 25px 31px;">
                                                                    <% if (child.Properties.HasProperty("icon")){ %>
                                                                        <i style="line-height:0px;" class="<% = child.Properties.GetPropertyValue("icon") %>"></i>
                                                                    <% } %>
                                                                    <% if (child.Properties.HasProperty("localize-key")){ %>
                                                                        <% =GetLocalResourceObject(child.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                                    <% }else{ %>
                                                                        <span><% = child.Name %></span>
                                                                    <% } %>
                                                                </a>
                                                                <% } %>
                                                            </li>
                                                        <% } %>
                                                    </ul>
                                                    <% }else{ %>
                                                    <a href="<% = mi.URL %>" style="padding: 25px 31px;">
                                                        <% if (mi.Properties.HasProperty("icon")){ %>
                                                            <i style="line-height:0px;" class="<% = mi.Properties.GetPropertyValue("icon") %>"></i>
                                                        <% } %>
                                                        <% if (mi.Properties.HasProperty("localize-key")){ %>
                                                            <% =GetLocalResourceObject(mi.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                        <% }else{ %>
                                                            <span><% = mi.Name %></span>
                                                        <% } %>
                                                    </a>
                                                    <% } %>
                                                </li>
                                                <% } %>
                                            </ul>
                                            <% }else{ %>
                                            <ul class="nav navbar-nav level0">
                                                <% foreach (WebApp.MenuItem mi in menuData.GetGroupItems("navbar_right_no_modules"))
                                                   { %>
                                                <li class="<% = (mi.Properties.HasProperty("classes")) ? mi.Properties.GetPropertyValue("classes") : "" %>" data-id="101" data-level="1">
                                                    <% if (mi.Children.Count > 0){ %>
                                                    <a class="dropdown-toggle" style="padding: 17px 31px;font-size: 18px;font-weight: normal;cursor:pointer;" data-toggle="dropdown">
                                                        <% if (mi.Properties.HasProperty("icon")){ %>
                                                            <i style="line-height:0px;" class="<% = mi.Properties.GetPropertyValue("icon") %>"></i>
                                                        <% } %>
                                                        <% if (mi.Properties.HasProperty("localize-key")){ %>
                                                            <% =GetLocalResourceObject(mi.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                        <% }else{ %>
                                                            <span><% = mi.Name %></span>
                                                        <% } %>
                                                        <span class="caret"></span>
                                                    </a>
                                                    <ul style="min-width:190px;margin-left:5px;color: rgb(0, 0, 0);" class="dropdown-menu">
                                                        <% foreach(WebApp.MenuItem child in mi.Children){ %>
                                                            <li class="<% = (child.Properties.HasProperty("classes")) ? child.Properties.GetPropertyValue("classes") : "" %>" data-id="101" data-level="1">
                                                                <% if (child.Children.Count > 0){ %>
                                                                <a class="dropdown-toggle" style="padding: 17px 31px;font-size: 18px;font-weight: normal;cursor:pointer;" data-toggle="dropdown">
                                                                    <% if (child.Properties.HasProperty("icon")){ %>
                                                                        <i style="line-height:0px;" class="<% = child.Properties.GetPropertyValue("icon") %>"></i>
                                                                    <% } %>
                                                                    <% if (child.Properties.HasProperty("localize-key")){ %>
                                                                        <% =GetLocalResourceObject(child.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                                    <% }else{ %>
                                                                        <span><% = child.Name %></span>
                                                                    <% } %>
                                                                    <span class="caret"></span>
                                                                </a>
                                                                <ul style="min-width:190px;margin-left:5px;color: rgb(0, 0, 0);" class="dropdown-menu">
                                                                    <% foreach(WebApp.MenuItem child1 in child.Children){ %>
                                                                        <a href="<% = child1.URL %>" style="padding: 25px 31px;">
                                                                            <% if (child1.Properties.HasProperty("icon")){ %>
                                                                                <i style="line-height:0px;" class="<% = child1.Properties.GetPropertyValue("icon") %>"></i>
                                                                            <% } %>
                                                                            <% if (child1.Properties.HasProperty("localize-key")){ %>
                                                                                <% =GetLocalResourceObject(child1.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                                            <% }else{ %>
                                                                                <span><% = child1.Name %></span>
                                                                            <% } %>
                                                                        </a>
                                                                    <% } %>
                                                                </ul>
                                                                <% }else{ %>
                                                                <a href="<% = child.URL %>" style="padding: 25px 31px;">
                                                                    <% if (child.Properties.HasProperty("icon")){ %>
                                                                        <i style="line-height:0px;" class="<% = child.Properties.GetPropertyValue("icon") %>"></i>
                                                                    <% } %>
                                                                    <% if (child.Properties.HasProperty("localize-key")){ %>
                                                                        <% =GetLocalResourceObject(child.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                                    <% }else{ %>
                                                                        <span><% = child.Name %></span>
                                                                    <% } %>
                                                                </a>
                                                                <% } %>
                                                            </li>
                                                        <% } %>
                                                    </ul>
                                                    <% }else{ %>
                                                    <a href="<% = mi.URL %>" style="padding: 25px 31px;">
                                                        <% if (mi.Properties.HasProperty("icon")){ %>
                                                            <i style="line-height:0px;" class="<% = mi.Properties.GetPropertyValue("icon") %>"></i>
                                                        <% } %>
                                                        <% if (mi.Properties.HasProperty("localize-key")){ %>
                                                            <% =GetLocalResourceObject(mi.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                        <% }else{ %>
                                                            <span><% = mi.Name %></span>
                                                        <% } %>
                                                    </a>
                                                    <% } %>
                                                </li>
                                                <% } %>
                                            </ul>
                                            <% } %>
                                            <ul class="nav navbar-nav level0">
                                                <% foreach (WebApp.MenuItem mi in menuData.GetGroupItems("navbar_right"))
                                                   { %>
                                                <li class="<% = (mi.Properties.HasProperty("classes")) ? mi.Properties.GetPropertyValue("classes") : "" %>" data-id="101" data-level="1">
                                                    <% if (mi.Children.Count > 0){ %>
                                                    <a class="dropdown-toggle" style="padding: 17px 31px;font-size: 18px;font-weight: normal;cursor:pointer;" data-toggle="dropdown">
                                                        <% if (mi.Properties.HasProperty("icon")){ %>
                                                            <i style="line-height:0px;" class="<% = mi.Properties.GetPropertyValue("icon") %>"></i>
                                                        <% } %>
                                                        <% if (mi.Properties.HasProperty("localize-key")){ %>
                                                            <% =GetLocalResourceObject(mi.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                        <% }else{ %>
                                                            <span><% = mi.Name %></span>
                                                        <% } %>
                                                        <span class="caret"></span>
                                                    </a>
                                                    <ul style="min-width:190px;margin-left:5px;color: rgb(0, 0, 0);" class="dropdown-menu">
                                                        <% foreach(WebApp.MenuItem child in mi.Children){ %>
                                                            <li class="<% = (child.Properties.HasProperty("classes")) ? child.Properties.GetPropertyValue("classes") : "" %>" data-id="101" data-level="1">
                                                                <% if (child.Children.Count > 0){ %>
                                                                <a class="dropdown-toggle" style="padding: 17px 31px;font-size: 18px;font-weight: normal;cursor:pointer;" data-toggle="dropdown">
                                                                    <% if (child.Properties.HasProperty("icon")){ %>
                                                                        <i style="line-height:0px;" class="<% = child.Properties.GetPropertyValue("icon") %>"></i>
                                                                    <% } %>
                                                                    <% if (child.Properties.HasProperty("localize-key")){ %>
                                                                        <% =GetLocalResourceObject(child.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                                    <% }else{ %>
                                                                        <span><% = child.Name %></span>
                                                                    <% } %>
                                                                    <span class="caret"></span>
                                                                </a>
                                                                <ul style="min-width:190px;margin-left:5px;color: rgb(0, 0, 0);" class="dropdown-menu">
                                                                    <% foreach(WebApp.MenuItem child1 in child.Children){ %>
                                                                        <a href="<% = child1.URL %>" style="padding: 25px 31px;">
                                                                            <% if (child1.Properties.HasProperty("icon")){ %>
                                                                                <i style="line-height:0px;" class="<% = child1.Properties.GetPropertyValue("icon") %>"></i>
                                                                            <% } %>
                                                                            <% if (child1.Properties.HasProperty("localize-key")){ %>
                                                                                <% =GetLocalResourceObject(child1.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                                            <% }else{ %>
                                                                                <span><% = child1.Name %></span>
                                                                            <% } %>
                                                                        </a>
                                                                    <% } %>
                                                                </ul>
                                                                <% }else{ %>
                                                                <a href="<% = child.URL %>" style="padding: 25px 31px;">
                                                                    <% if (child.Properties.HasProperty("icon")){ %>
                                                                        <i style="line-height:0px;" class="<% = child.Properties.GetPropertyValue("icon") %>"></i>
                                                                    <% } %>
                                                                    <% if (child.Properties.HasProperty("localize-key")){ %>
                                                                        <% =GetLocalResourceObject(child.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                                    <% }else{ %>
                                                                        <span><% = child.Name %></span>
                                                                    <% } %>
                                                                </a>
                                                                <% } %>
                                                            </li>
                                                        <% } %>
                                                    </ul>
                                                    <% }else{ %>
                                                    <a href="<% = mi.URL %>" style="padding: 25px 31px;">
                                                        <% if (mi.Properties.HasProperty("icon")){ %>
                                                            <i style="line-height:0px;" class="<% = mi.Properties.GetPropertyValue("icon") %>"></i>
                                                        <% } %>
                                                        <% if (mi.Properties.HasProperty("localize-key")){ %>
                                                            <% =GetLocalResourceObject(mi.Properties.GetLocalizePropertyValue("localize-key")).ToString() %>
                                                        <% }else{ %>
                                                            <span><% = mi.Name %></span>
                                                        <% } %>
                                                    </a>
                                                    <% } %>
                                                </li>
                                                <% } %>
                                            </ul>
                                            <div class="nav" id="loginView_holder">
                                                <!-- here goes the sign-in form or the user logged view --->
                                            </div>
                                            <div class="nav" style="color: #fff !important; width:100px; height:51px;" id="clockView_holder">
                                            <!-- here goes the app clock --->
                                            </div>
                                            <ul class="nav navbar-nav level0">
                                                <li style="visibility:hidden;" id="configuration_icon">
                                                    <a href="!/ih/configuration" style="padding: 25px 31px;">
                                                        <i style="line-height:0px;" class="fw-icon-cog fw-icon-large"></i>
                                                    </a>
                                                    <div id="configuration_error_icon">
                                                        <i  class="fa fa-remove"></i>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </nav>
                        <!-- //MAIN NAVIGATION -->
                    </div>
                </div>
            </div>
        </div>
    </header>

    <%--<div class="navbar navbar-fixed-top">
        <div class="navbar-inner">
            <div class="container-fluid">
                <button type="button" class="btn btn-navbar" data-toggle="collapse" data-target=".nav-collapse">
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>
                <a class="brand hidden-desktop screen-title-text"></a>
                <div class="nav-collapse collapse">
                    <div class="hidden-tablet hidden-phone" style="width:100%;height:0;text-align:center;">
                        <span id="top_nav_spinner" class="top-nav-spinner hide-spinner animated"></span>
                        <h4 id="screen_title" class="screen-title hide-title animated"></h4>
                    </div>
                    <div id="menu_holder">
                        <!-- here goes the menu, according to the user logged shows more or less options --->
                        <a class="brand"><asp:Localize ID="Localize5" runat="server" meta:resourcekey="brand_title" /></a>
                    </div>
                    <ul style="display:none !important;" class="nav visible-desktop hide">
                        <li class="dropdown visible-desktop">
                            <a id="drop1" class="dropdown-toggle" data-toggle="dropdown" style="cursor:pointer;">
                            <asp:Localize runat="server" meta:resourcekey="change_language" /><b class="caret"></b>
                            </a>
                            <ul class="dropdown-menu" role="menu" aria-labelledby="drop1" id="items-container-desktop">
                                <li><a data-bypass="" href="<%= ResolveUrl("~/setLanguage.aspx?lang=ES") %>"><asp:Localize runat="server" meta:resourcekey="change_es" /></a></li>
                                <li><a data-bypass="" href="<%= ResolveUrl("~/setLanguage.aspx?lang=EN") %>"><asp:Localize runat="server" meta:resourcekey="change_en" /></a></li>
                                <li><a data-bypass="" href="<%= ResolveUrl("~/setLanguage.aspx?lang=FR") %>"><asp:Localize runat="server" meta:resourcekey="change_fr" /></a></li>
                            </ul>
                        </li>
                    </ul>
                    <div class="nav pull-right">
                        <div class="nav" id="loginView_holder">
                            <!-- here goes the sign-in form or the user logged view --->
                        </div>
                        <div class="nav span1" id="clockView_holder">
                            <!-- here goes the app clock --->
                        </div>
                        <ul style="width:120px;" class="nav span2">
                            <!-- cog configuration icon -->
                            <li style="visibility:hidden;" id="configuration_icon"><a href="!/ih/configuration"><i class="fw-icon-cog fw-icon-large"></i><span style="margin-left:5px;"></span></a></li>
                        </ul>
                    </div>
                </div><!--/.nav-collapse -->
            </div>
        </div>
    </div>--%>

    <div id="loading" style="display:block;" class="loading-big-wrapper">
        <div class="loading-inner-wrapper">
            <h4><asp:Localize ID="Localize1" runat="server" meta:resourcekey="loading_text" /></h4>
            <div class="system-progress-bar progress progress-striped active">
                <div class="bar" style="width: 100%;"></div>
            </div>
            <div id="timeout_connection_error" style="display:none;" class="timeout-connection-error">
                <h5>
                    <asp:Localize ID="Localize2" runat="server" meta:resourcekey="timeout_slow_connection_message" />
                    <a href="javascript:location.reload()"><asp:Localize ID="Localize3" runat="server" meta:resourcekey="reload_action" /></a>
                </h5>
            </div>
        </div>
    </div>

    <script>
        //adding timeout error timeout for slow connections
        setTimeout(function () {
            if (document.getElementById('loading').style.display == "block") {
                document.getElementById('timeout_connection_error').style.display = "block"; 
            }
        }, 10000); 
    </script>

    <div id="content_container" class="content-container hide-subnavbar">
        <!-- rowfluid that acts as a subnavbar with 59px height -->
        <div class="row-fluid fixed-subnavbar">
            <div class="span12 offset0 subnavbar-span-offset" id="subnavbar_holder">
            </div>
        </div>
        <div class="container-fluid content-inner-container">
            <div id="content" class="row-fluid content">
            </div>
        </div> <!-- /container-fluid -->
    </div>

    <!-- loading scripts via link and script tags cause the includer was taking too much, also sometimes we would get
        an error that a script could not be loaded. this is temporary solution until we find a better way to load these -->

    <link href="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/IndustrialContainer/Styles/IndustrialContainer.css?v=" + version) %>" rel="stylesheet" />
    <link href="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/ForeignFiles/JSColor/Styles/jscolor.css?v=" + version) %>" rel="stylesheet" />
    <link href="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/IndustrialGrid/Styles/IndustrialGrid.css?v=" + version) %>" rel="stylesheet" />
    <link href="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/IndustrialChart/Styles/IndustrialChart.css?v=" + version) %>" rel="stylesheet" />

    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/ForeignFiles/canvas/Scripts/excanvas.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/ForeignFiles/canvas/Scripts/dateformat.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/ForeignFiles/canvas/Scripts/canvastext.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Addons/Export/Scripts/export.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/DropDownSelect/Scripts/dropdownselect.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/IndustrialContainer/Scripts/IndustrialContainer.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/ForeignFiles/JSColor/Scripts/jscolor.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/IndustrialGrid/Scripts/IndustrialGrid.js?v=" + version) %>"></script>
    <script src="<%= ResolveUrl(VirtualPathUtility.GetDirectory(Request.ApplicationPath) + "IndustrialDashboard/Widgets/IndustrialChart/Scripts/IndustrialChart.js?v=" + version) %>"></script>

    <script>
        Core.DOM.Ready(function () {
            //this is the FIRST thing that get executed in the app, the DOM Ready is called by the includer after
            //it's done loading everything it needs.

            var configPath = "<%= ResolveUrl("~/app/")%>"; 

            window.webapp_version = "<% = version %>"; 

            //settings the baseURL for the requirejs
            require.config({
                baseUrl: configPath,
                urlArgs: "<% = version %>",
            });

            //calling the config.js file thats in /app/config.js
            //this will reconfigure requirejs and also call the require.config.js (JAM) as a dependency

            require(['require-config'], function () {
            });
        });
    </script>

</asp:Content>

